#ifndef SCIP_HANDLER_H
#define SCIP_HANDLER_H

/*!
  \file
  \brief SCIP 通信処理

  \author Satofumi KAMIMURA

  $Id: ScipHandler.h 290 2008-10-22 15:35:54Z satofumi $
*/

#include "CaptureSettings.h"
#include <memory>
#include <vector>


namespace qrk
{
  class Connection;
  class RangeSensorParameter;

  class ScipHandler
  {
    ScipHandler(const ScipHandler& rhs);
    ScipHandler& operator = (const ScipHandler& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    static const bool Off = false;
    static const bool On = true;
    static const bool Force = true;

    ScipHandler(void);
    ~ScipHandler(void);

    const char* what(void) const;

    static long encode(const char* data, int size);
    static bool checkSum(char* buffer, int size, char actual_sum);

    void setConnection(Connection* con);
    Connection* connection(void);

    // ボーレートを合わせた上でのデバイスとの接続
    bool connect(const char* device, long baudrate);

    int send(const char data[], int size);
    int recv(char data[], int size, int timeout);

    // URG デバイスからのパラメータの読み出し
    bool loadParameter(RangeSensorParameter& parameters);

    bool versionLines(std::vector<std::string>& lines);

    //! タイムスタンプのモードに遷移する
    bool setRawTimestampMode(bool on);

    bool rawTimestamp(int* timestamp);

    bool setLaserOutput(bool on, bool force = false);

    CaptureType receiveCaptureData(std::vector<long>& data, int* timestamp,
                                   int* remain_times);

    // !!! １行毎のデータを格納すると、距離配列を作成してくれるメソッド
    // !!! 書き込み先、のポインタを保持しておけばよい

    // !!! 強度データの考慮をしてくれると、うれしい
    // !!! URG の場合、１スキャンの距離、１スキャンの強度、で届き
    // !!! Top-URG の場合、１ステップの距離、１ステップの強度、で届く


    // !!! 格納が完了するまで戻らないブロッキング形式にするか
    // !!! 途中の状態を保持しての、ノンブロックにするかは未定
    // !!! 可能ならば、ノンブロックにする

    // 返却する data については
    // !!! 基本的に、毎回 area_max だけのデータを返す
    // !!! データ間引きが指定されていた場合は、埋める
    // !!!

    // !!! ノンブロックの場合、
    // !!! - データ書き込み先ポインタのセット
    // !!! - データ読みだし指示
    // !!! - 読みだし完了か、エラーか、途中か、の状態取得
    // !!! - swap() 相当の関数
    // !!! が必要そう


    // !!! QT の応答は、MD の次に来る可能性がある
  };
};

#endif /* !SCIP_HANDLER_H */
