#ifndef CAPTURE_SETTINGS_H
#define CAPTURE_SETTINGS_H

/*!
  \file
  \brief データ取得設定

  \author Satofumi KAMIMURA

  $Id: CaptureSettings.h 279 2008-10-16 21:38:59Z satofumi $
*/

namespace qrk
{
  /*!
    \brief 受信データのタイプ
  */
  typedef enum {
    TypeUnknown,                //!< 不明
    QT,
    GD,
    GS,
    MD,
    MS,
    ME,
    Mx_Reply,                   //!< Mx コマンドの最初の応答メッセージ
    InvalidData,                //!< 受信データのエラー
  } CaptureType;


  class CaptureSettings
  {
  public:
    CaptureType type;           //!< 受信データの種類
    int error_code;             //!< エラーコード
    long timestamp;             //!< タイムスタンプ [msec]
    int capture_first;          //!< 取得開始インデックス
    int capture_last;           //!< 取得終了インデックス
    int skip_lines;             //!< 間引きライン数
    int skip_frames;            //!< データ取得間隔
    int remain_times;           //!< データ取得の残り回数
    int data_byte;              //!< データバイト数

    CaptureSettings(void)
      : type(TypeUnknown), error_code(-1), timestamp(-1),
        capture_first(-1), capture_last(-1),
        skip_lines(-1), skip_frames(-1), remain_times(-1), data_byte(-1)
    {
    }
  };
};

#endif /*! CAPTURE_SETTINGS_H */
