#ifndef URG_CTRL_H
#define URG_CTRL_H

/*!
  \file
  \brief URG センサ制御

  \author Satofumi KAMIMURA

  $Id: UrgCtrl.h 299 2008-10-26 12:15:43Z satofumi $

  \todo レーザ出力の On/Off 関数を追加する
*/

#include "RangeSensor.h"
#include "Coordinate.h"
#include "RangeCaptureMode.h"


namespace qrk
{
  class Connection;
  class RangeSensorParameter;

  /*!
    \brief URG センサ制御
  */
  class UrgCtrl : public Coordinate, public RangeSensor
  {
    UrgCtrl(const UrgCtrl& rhs);
    UrgCtrl& operator = (const UrgCtrl& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    enum {
      DefaultBaudrate = 115200,
      Infinity = 0,
    };

    static const bool Off = false;
    static const bool On = true;

    UrgCtrl(void);
    ~UrgCtrl(void);

    const char* what(void) const;

    bool connect(const char* device, long baudrate = DefaultBaudrate);
    void setConnection(Connection* con);
    Connection* connection(void);
    void disconnect(void);
    bool isConnected(void);

    long minDistance(void) const;
    long maxDistance(void) const;
    int maxScanLines(void) const;

    void setCapturesSize(size_t size);

    int scanMsec(void) const;

    void setCaptureMode(RangeCaptureMode mode);
    RangeCaptureMode captureMode(void);

    void setCaptureRange(int begin_index, int end_index);
    void setCaptureFrameInterval(size_t interval);
    void setCaptureTimes(size_t times);
    size_t remainCaptureTimes(void);
    void setCaptureSkipLines(size_t skip_lines);

    int capture(std::vector<long>& data, int* timestamp = NULL);
    int captureIntensity(std::vector<long>& data, int* timestamp = NULL);

    void stop(void);

    bool setTimestamp(int ticks = 0);

    bool setLaserOutput(bool on);

    double index2rad(const int index) const;
    int rad2index(const double radian) const;

    void setParameter(const RangeSensorParameter& parameter);
    RangeSensorParameter parameter(void);
    bool loadParameter(void);

    bool versionLines(std::vector<std::string>& lines);
  };
};

#endif /* !URG_CTRL_H */
