/*!
  \file
  \brief 待機関数

  \author Satofumi KAMIMURA

  $Id: delay.cpp 222 2008-09-17 12:52:15Z satofumi $
*/

#include <SDL.h>
#include "delay.h"
#include "SdlInit.h"


namespace
{
  class DelayInit : private qrk::SdlInit
  {
  };

  static double delay_ratio_ = 1.0;
};


void qrk::delay(int msec)
{
  // 初期化用
  static DelayInit sdl_init;

  SDL_Delay(static_cast<int>(msec * delay_ratio_));
}


void qrk::setDelayRatio(double ratio)
{
  delay_ratio_ = ratio;
}
