#ifndef THREAD_H
#define THREAD_H

/*!
  \file
  \brief スレッド処理のラッパー

  \author Satofumi KAMIMURA

  $Id: Thread.h 226 2008-09-20 15:40:36Z satofumi $
*/

#include <memory>


namespace qrk
{
  /*!
    \brief スレッド処理
  */
  class Thread
  {
    Thread(void);
    Thread(const Thread& rhs);
    Thread& operator = (const Thread& rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;

  public:
    enum {
      Infinity = -1,
    };
    explicit Thread(int (*fn)(void *), void* args);
    ~Thread(void);


    /*!
      \brief 処理回数を指定してスレッドを起動

      \param[in] times 処理回数
    */
    void run(int times = Infinity);


    /*!
      \brief スレッドを停止
    */
    void stop(void);


    /*!
      \brief スレッドの終了を待つ

      \return スレッドの戻り値
    */
    int wait(void);


    /*!
      \brief スレッドが動作中かを返す

      \retval true 動作中
      \retval false 停止中
    */
    bool isRunning(void);
  };
};

#endif /* !THREAD_H */
