#ifndef M_URG_CTRL_H
#define M_URG_CTRL_H

/*!
  \file
  \brief モニタ対応の URG 制御

  \todo UrgCtrl を包含でなく継承にするか、を検討する

  \author Satofumi KAMIMURA

  $Id: mUrgCtrl.h 290 2008-10-22 15:35:54Z satofumi $
*/

#include "UrgCtrl.h"


namespace qrk
{
  class mUrgCtrl : public RangeSensor
  {
    mUrgCtrl(void);
    mUrgCtrl(const mUrgCtrl& rhs);
    mUrgCtrl& operator = (const mUrgCtrl& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    enum {
      DefaultBaudrate = 115200,
    };
    explicit mUrgCtrl(int argc, char *argv[]);
    ~mUrgCtrl(void);

    const char* what(void) const;

    bool connect(const char* device, long baudrate = DefaultBaudrate);
    void setConnection(Connection* con);
    Connection* connection(void);
    void disconnect(void);
    bool isConnected(void);

    long minDistance(void) const;
    long maxDistance(void) const;
    int maxScanLines(void) const;

    int scanMsec(void) const;

    void setCaptureMode(RangeCaptureMode mode);
    RangeCaptureMode captureMode(void);

    void setCaptureRange(int begin_index, int end_index);
    void setCaptureFrameInterval(size_t interval);
    void setCaptureTimes(size_t times);
    void setCaptureSkipLines(size_t skip_lines);

    int capture(std::vector<long>& data, int* timestamp = NULL);
    int captureIntensity(std::vector<long>& data, int* timestamp = NULL);

    void stop(void);

    bool setTimestamp(int ticks = 0);

    bool setLaserOutput(bool on);

    double index2rad(const int index) const;
    int rad2index(const double radian) const;

    void setParameter(const RangeSensorParameter& parameter);
    RangeSensorParameter parameter(void);

    bool versionLines(std::vector<std::string>& lines);
  };
};

#endif /* !M_URG_CTRL_H */
