#ifndef DEVICE_IP_MANAGER_H
#define DEVICE_IP_MANAGER_H

/*!
  \file
  \brief シミュレータ接続用の IP ポート管理

  \author Satofumi KAMIMURA

  $Id: DeviceIpManager.h 224 2008-09-20 09:52:00Z satofumi $
*/

#include <memory>


namespace qrk
{
  class DeviceIpManager
  {
    DeviceIpManager(void);
    DeviceIpManager(const DeviceIpManager& rhs);
    DeviceIpManager& operator = (const DeviceIpManager& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    ~DeviceIpManager(void);
    static DeviceIpManager* singleton(void);

    long createIpPort(const char* device, int sub_id = 0);
  };
};

#endif /* !DEVICE_IP_MANAGER_H */
