#ifndef COORDINATE_H
#define COORDINATE_H

/*!
  \file
  \brief 座標系の制御

  \author Satofumi KAMIMURA

  $Id: Coordinate.h 299 2008-10-26 12:15:43Z satofumi $

  \todo Root が宣言できたら、NULL を置き換える
*/

#include "PositionTypes.h"
#include <vector>
#include <memory>


namespace qrk {
  class Coordinate
  {
    Coordinate(const Coordinate& rhs);
    Coordinate& operator = (const Coordinate& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    // !!! プリミティブ型でないと、宣言できないのか？
    //static const Coordinate* Root = NULL;

    Coordinate(void);

    //! parent が NULL のとき、offset 指定は無視される
    Coordinate(Coordinate* parent, const qrk::Position<int>& offset);
    virtual ~Coordinate(void);

    Coordinate* parent(void);
    const std::vector<Coordinate*> children(void);

    void addChild(Coordinate* child);
    void addChild(Coordinate* child, const qrk::Position<int>& offset);
    void addChildToModule(Coordinate* child);
    void addChildToModule(Coordinate* child, const qrk::Position<int>& offset);

    // 指定された子座標系の原点位置を、自座標系のどこに配置しているかを返す
    qrk::Position<int> offset(const Coordinate* child) const;

    virtual qrk::Position<int> position(Coordinate* coordinate = NULL)
    {
      return originPosition(coordinate);
    }

    //! 自オブジェクトの原点が、指定座標系のどこにあるのかを返す
    qrk::Position<int> originPosition(Coordinate* coordinate = NULL);

    //! 自オブジェクトの指定点が、指定座標系のどこにあるのかを返す
    qrk::Position<int> pointPosition(Coordinate* coordinate,
                                     const qrk::Position<int>& position);
  };
};

#endif /* !COORDINATE_H */
