#ifndef IS_USING_COM_DRIVER_H
#define IS_USING_COM_DRIVER_H

/*!
  \file
  \brief 指定ドライバが利用中かを判断する

  \author Satofumi KAMIMURA

  $Id: isUsingComDriver.h 176 2008-08-27 07:52:06Z satofumi $
*/

namespace qrk
{
  /*!
    \brief 指定ドライバを利用している COM ポートが存在するかを返す

    \param[in] com_port 判定を行う COM ポート
    \param[i] driver_name 判定を行うドライバ名

    \retval true 指定ドライバの COM ポートが存在する
    \retval false 存在しない

    \attention Windows 環境でなければ常に false を返す
    \attention 動作確認は、Windows XP のみ。他では未検証
  */
  bool isUsingComDriver(const char* com_port, const char* driver_name);
};

#endif /* !IS_USING_COM_DRIVER_H */
