#ifndef FIND_COM_PORTS_H
#define FIND_COM_PORTS_H

/*!
  \file
  \brief COM ポート一覧の取得

  \author Satofumi KAMIMURA

  $Id: FindComPorts.h 173 2008-08-25 13:47:25Z satofumi $

  \attention 動作確認は Windows XP のみ。他では未検証
*/

#include <string>
#include <vector>


namespace qrk
{
  class IsUsbCom;

  /*!
    \brief シリアルポートの探索を行う

    Windows では、レジストリ情報を元に COM 一覧を取得して返す。\n
    Linux, MacOS では、与えられたパターンに一致するファイル名を取得して返す。
  */
  class FindComPorts
  {
    FindComPorts(const FindComPorts& rhs);
    FindComPorts& operator = (const FindComPorts& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    FindComPorts(IsUsbCom* is_usb = NULL);
    ~FindComPorts(void);

    void clear(void);
    void addBaseName(const char* base_name);
    std::vector<std::string> baseNames(void);

    /*!
      \brief COM ポート一覧の取得

      \retval COM 一覧が格納された string 配列
    */
    std::vector<std::string> find(void);
  };
};

#endif /* !FIND_COM_PORTS_H */
