/*!
  \file
  \brief string 用の split 関数

  boost を使わずに実装

  \author Satofumi KAMIMURA

  $Id: split.cpp 188 2008-08-30 12:23:34Z satofumi $
*/

#include "split.h"


// 区切り文字を、空白に置き換えて分割を行う
size_t qrk::split(std::vector<std::string>& tokens,
                  const std::string& line, const char* split_pattern)
{
  size_t next_first = 0;
  while (true) {

    // パターンでない文字位置を探す
    size_t first_position = line.find_first_not_of(split_pattern, next_first);
    if (first_position == std::string::npos) {
      // 以降にトークンがないため、中断
      break;
    }

    // バターンの終わりを探す
    size_t last_position = line.find_first_of(split_pattern, first_position);
    size_t length = std::string::npos;
    if (last_position != std::string::npos) {
      length = last_position - first_position;
    }
    tokens.push_back(line.substr(first_position, length));

    if (next_first == std::string::npos) {
      // 最後まで探索したため、中断
      break;
    }

    next_first = last_position;
  }
  return tokens.size();
}
