/*!
  \file
  \brief GD コマンドによるデータ取得サンプル

  \author Satofumi KAMIMURA

  $Id: gdCaptureSample.cpp 290 2008-10-22 15:35:54Z satofumi $
*/

#include "UrgCtrl.h"

using namespace qrk;


int main(int argc, char *argv[])
{
  //const char device[] = "COM3";
  const char device[] = "/dev/ttyACM0";

  UrgCtrl urg;
  if (! urg.connect(device)) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  // GD コマンドで１スキャン分のデータ取得を行い、指定回数だけ出力する
  enum { CaptureTimes = 1 };
  for (int i = 0; i < CaptureTimes; ++i) {
    int timestamp = -1;
    std::vector<long> data;

    int n = urg.capture(data, &timestamp);

    printf("timestamp: %d\n", timestamp);
    for (int j = 0; j < n; ++j) {
      printf("%d:%ld, ", j, data[j]);
    }
    printf("\n");
  }
  return 0;
}
