/*!
  \file
  \brief FindUrgPorts の動作サンプル

  \author Satofumi KAMIMURA

  $Id: findUrgPortsSample.cpp 285 2008-10-20 01:14:11Z satofumi $
*/

#include "UrgUsbCom.h"
#include "FindComPorts.h"
#include <SDL.h>

using namespace qrk;


//! main
int main(int argc, char *argv[]) {

  UrgUsbCom urg_usb;
  FindComPorts urg_finder(&urg_usb);
  std::vector<std::string> ports = urg_finder.find();

  // 見付かったポートを全て出力する
  printf("ports: %d\n", ports.size());
  for (std::vector<std::string>::iterator it = ports.begin();
       it != ports.end(); ++it) {
    printf("%s\n", it->c_str());
  }

  return 0;
}
