/*!
  \file
  \brief 複数 URG を用いてデータ取得を行うサンプル

  ２台の URG を用いて、それぞれの前方データを表示する

  \author Satofumi KAMIMURA

  $Id: multi_urg.c 260 2008-10-08 10:39:09Z satofumi $
*/

#include "urg_ctrl.h"
#include <stdio.h>
#include <stdlib.h>


static void urg_exit(urg_t *urg, const char *message) {

  printf("%s: %s\n", message, urg_error(urg));
  urg_disconnect(urg);

  exit(1);
}


//! main
int main(int argc, char *argv[]) {

  enum { Times = 99 };

  urg_t urg[2];
  long *data[2];
  int data_max[2];
  int timestamp;
  int ret;
  int n;
  int i;
  //int j;
  int k;

  //const char *connect_devices[] = { "COM3", "COM4" };
  const char *connect_devices[] = { "/dev/ttyACM0", "/dev/ttyACM1" };

  // 接続
  for (i = 0; i < 2; ++i) {
    ret = urg_connect(&urg[i], connect_devices[i], 115200);
    if (ret < 0) {
      printf("urg_connect: %s\n", urg_error(&urg[i]));
      exit(1);
    }
    // 既存の MD コマンドのクリア用
    urg_laserOff(&urg[i]);

    // データを間引くと、連続転送が容易になる
    // 間引き指定が 2 だと、データ転送量は半分になる
    //urg_setSkipLines(&urg[i], 2);

    /* 受信バッファの確保 */
    data_max[i] = urg_dataMax(&urg[i]);
    data[i] = (long*)malloc(sizeof(long) * data_max[i]);
    if (data[i] == NULL) {
      perror("data buffer");
      exit(1);
    }
  }

  /* MD でのデータ要求 */
  for (i = 0; i < 2; ++i) {
    urg_setCaptureTimes(&urg[i], Times);
    ret = urg_requestData(&urg[i], URG_MD, URG_FIRST, URG_LAST);
    if (ret < 0) {
      urg_exit(&urg[i], "urg_requestData()");
    }
  }

  for (k = 0; k < Times; ++k) {

    for (i = 0; i < 2; ++i) {
      printf("    %d: ", i);
      /* データ取得が完了していたら、終了 */
      int remain_times = urg_remainCaptureTimes(&urg[i]);
      printf("(%03d/%03d): ", remain_times, Times);
      if (remain_times <= 0) {
        continue;
      }

      /* データ取得 */
      n = urg_receiveData(&urg[i], data[i], data_max[i]);
      if (n < 0) {
        urg_exit(&urg[i], "urg_receiveData()");
      }

      /* 表示 */
      timestamp = urg_recentTimestamp(&urg[i]);
      printf("timestamp: %d, ", timestamp);
#if 0
      for (j = 0; j < n; ++j) {
        printf("%d:%ld, ", j, data[i][j]);
      }
      printf("\n\n");
#endif
    }
    printf("\n");
  }

  // 切断
  for (i = 0; i < 2; ++i) {
    urg_disconnect(&urg[i]);
    free(data[i]);
  }

  return 0;
}
