/*!
  \file
  \brief 角度変換のサンプル

  URG の角度とインデックスを変換した結果を出力する

  \author Satofumi KAMIMURA

  $Id: index_convert.c 136 2008-07-29 10:27:20Z satofumi $
*/

#include <stdio.h>
#include <stdlib.h>
#include "urg_ctrl.h"


//! main
int main(int argc, char *argv[]) {

  //const char device[] = "COM3"; /* Windows での例 */
  const char device[] = "/dev/ttyACM0"; /* Linux での例 */

  int ret = 0;
  int n;
  int i;

  /* 接続 */
  urg_t urg;
  ret = urg_connect(&urg, device, 115200);
  if (ret < 0) {
    printf("urg_connect: %s\n", urg_error(&urg));
    exit(1);
  }

  /* インデックス毎の角度を出力する */
  n = urg_dataMax(&urg);
  for (i = 0; i < n; i += 8) {
    double radian = urg_index2rad(&urg, i);
    int degree = urg_index2deg(&urg, i);
    printf("%03d, %d [deg], %.1f [rad], %d, %d\n", i, degree, radian,
           urg_deg2index(&urg, degree), urg_rad2index(&urg, radian));
  }

  return 0;
}
