/*!
  \file
  \brief タイムスタンプの取得サンプル

  TM0, TM1, TM2 コマンドを用いて、タイムスタンプを取得する

  \author Satofumi KAMIMURA

  $Id: get_timestamp.c 136 2008-07-29 10:27:20Z satofumi $
*/

#include <stdio.h>
#include <stdlib.h>
#include "urg_ctrl.h"


//! main
int main(int argc, char *argv[]) {

  enum {
    CaptureTimes = 10,
  };

  //const char device[] = "COM3"; /* Windows での例 */
  const char device[] = "/dev/ttyACM0"; /* Linux での例 */

  long timestamp = 0;
  int ret = 0;
  int i;

  /* 接続 */
  urg_t urg;
  ret = urg_connect(&urg, device, 115200);
  if (ret < 0) {
    printf("urg_connect: %s\n", urg_error(&urg));
    exit(1);
  }

  /* タイムスタンプモードに遷移し、タイムスタンプを表示する */
  urg_enableTimestampMode(&urg);
  for (i = 0; i < CaptureTimes; ++i) {
    timestamp = urg_currentTimestamp(&urg);
    printf("%02d: timestamp: %ld [msec]\n", i, timestamp);
  }
  urg_disableTimestampMode(&urg);

  return 0;
}
