#ifndef M_DIFFERENTIAL_DRIVE_H
#define M_DIFFERENTIAL_DRIVE_H

/*!
  \file
  \brief モニタ対応の走行制御クラス

  \author Satofumi KAMIMURA

  $Id: mDifferentialDrive.h 283 2008-10-19 21:31:36Z satofumi $
*/

#include "DifferentialDrive.h"


namespace qrk
{
  class mDifferentialDrive : public RunCtrl
  {
    mDifferentialDrive(void);
    mDifferentialDrive(const mDifferentialDrive& rhs);
    mDifferentialDrive& operator = (const mDifferentialDrive& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    enum {
      DefaultBaudrate = 115200,
    };
    explicit mDifferentialDrive(int argc, char *argv[]);
    ~mDifferentialDrive(void);

    const char* what(void) const;

    void pushState(void);
    void popState(void);

    bool connect(const char* device, long baudrate = DefaultBaudrate);
    bool connect(Connection* con);
    void setConnection(Connection* con);
    Connection* connection(void);
    void disconnect(void);
    bool isConnected(void);

    void setServo(bool on);

    void followLine(const Position<int>& position);
    void followCircle(const Grid<int>& point, const int radius);

    void stopToLine(const Grid<int>& point, const Angle& angle);
    void stopToDirection(const Angle& angle);

    void rotateAngle(const Angle& angle);
    void rotate(const Angle& angle_sec);

    void stop(void);

    Position<int> position(Coordinate* coordinate, int* timestamp);
    bool isStable(void);

    void setStraightVelocity(int mm_sec);
    int straightVelocity(void);

    void setStraightAcceleration(int mm_sec2);

    void setRotateVelocity(const Angle& angle_sec);
    Angle rotateVelocity(void);
    void setRotateAcceleration(const Angle& angle_sec2);
  };
};

#endif /* !M_DIFFERENTIAL_DRIVE_H */
