/*!
  \file
  \brief モニタ対応の走行制御クラス

  \author Satofumi KAMIMURA

  $Id: mDifferentialDrive.cpp 283 2008-10-19 21:31:36Z satofumi $
*/

#include "mDifferentialDrive.h"

using namespace qrk;


struct mDifferentialDrive::pImpl
{
  DifferentialDrive run;
};


mDifferentialDrive::mDifferentialDrive(int argc, char *argv[])
  : pimpl(new pImpl)
{
}


mDifferentialDrive::~mDifferentialDrive(void)
{
}


const char* mDifferentialDrive::what(void) const
{
  return pimpl->run.what();
}


void mDifferentialDrive::pushState(void)
{
  pimpl->run.pushState();
}


void mDifferentialDrive::popState(void)
{
  pimpl->run.popState();
}


bool mDifferentialDrive::connect(const char* device, long baudrate)
{
  return pimpl->run.connect(device, baudrate);
}


bool mDifferentialDrive::connect(Connection* con)
{
  return pimpl->run.connect(con);
}


void mDifferentialDrive::setConnection(Connection* con)
{
  pimpl->run.setConnection(con);
}


Connection* mDifferentialDrive::connection(void)
{
  return pimpl->run.connection();
}


void mDifferentialDrive::disconnect(void)
{
  pimpl->run.disconnect();
}


bool mDifferentialDrive::isConnected(void)
{
  return pimpl->run.isConnected();
}


void mDifferentialDrive::setServo(bool on)
{
  pimpl->run.setServo(on);
}


void mDifferentialDrive::followLine(const Position<int>& position)
{
  pimpl->run.followLine(position);
}


void mDifferentialDrive::followCircle(const Grid<int>& point, const int radius)
{
  pimpl->run.followCircle(point, radius);
}


void mDifferentialDrive::stopToLine(const Grid<int>& point, const Angle& angle)
{
  pimpl->run.stopToLine(point, angle);
}


void mDifferentialDrive::stopToDirection(const Angle& angle)
{
  pimpl->run.stopToDirection(angle);
}


void mDifferentialDrive::rotateAngle(const Angle& angle)
{
  pimpl->run.rotateAngle(angle);
}


void mDifferentialDrive::rotate(const Angle& angle_sec)
{
  pimpl->run.rotate(angle_sec);
}


void mDifferentialDrive::stop(void)
{
  pimpl->run.stop();
}


Position<int> mDifferentialDrive::position(Coordinate* coordinate,
                                           int* timestamp)
{
  return pimpl->run.position(coordinate, timestamp);
}


bool mDifferentialDrive::isStable(void)
{
  return pimpl->run.isStable();
}


void mDifferentialDrive::setStraightVelocity(int mm_sec)
{
  pimpl->run.setStraightVelocity(mm_sec);
}


int mDifferentialDrive::straightVelocity(void)
{
  return pimpl->run.straightVelocity();
}


void mDifferentialDrive::setStraightAcceleration(int mm_sec2)
{
  pimpl->run.setStraightAcceleration(mm_sec2);
}


void mDifferentialDrive::setRotateVelocity(const Angle& angle_sec)
{
  pimpl->run.setRotateVelocity(angle_sec);
}


Angle mDifferentialDrive::rotateVelocity(void)
{
  return pimpl->run.rotateVelocity();
}


void mDifferentialDrive::setRotateAcceleration(const Angle& angle_sec2)
{
  pimpl->run.setRotateAcceleration(angle_sec2);
}
