#ifndef M_CAMERA_CTRL_H
#define M_CAMERA_CTRL_H

/*!
  \file
  \brief モニタ対応のカメラ制御

  \author Satofumi KAMIMURA

  $Id: mCameraCtrl.h 286 2008-10-20 09:40:22Z satofumi $
*/

#include <memory>


namespace qrk
{
  class mCameraCtrl
  {
    mCameraCtrl(const mCameraCtrl& rhs);
    mCameraCtrl& operator = (const mCameraCtrl& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    mCameraCtrl(void);
    ~mCameraCtrl(void);

    const char* what(void);

    bool connect(void);
    void disconnect(void);

    void setCaptureSize(int width, int height);
    bool capture(const char* fileName = "capture.jpg");
  };
};

#endif /* !M_CAMERA_CTRL_H */
