#ifndef URG_SERVER_H
#define URG_SERVER_H

/*!
  \file
  \brief シミュレータ用の URG サーバ

  \author Satofumi KAMIMURA

  $Id: UrgServer.h 226 2008-09-20 15:40:36Z satofumi $
*/

#include "DeviceServer.h"
#include <memory>


namespace qrk
{
  class UrgServer : public DeviceServer
  {
    UrgServer(const UrgServer& rhs);
    UrgServer& operator = (const UrgServer& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    UrgServer(void);
    ~UrgServer(void);

    bool activate(long port);
    int updateInterval(void);
    void update(void);
  };
};

#endif /* !URG_SERVER_H */
