/*!
  \file
  \brief MonitorModeManager のテスト

  \author Satofumi KAMIMURA

  $Id: TestMonitorModeManager.cpp 170 2008-08-24 21:16:53Z satofumi $
*/

#include "TestMonitorModeManager.h"
#include "MonitorModeManager.h"

using namespace qrk;


CPPUNIT_TEST_SUITE_REGISTRATION(TestMonitorModeManager);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TestMonitorModeManager,
                                      "TestMonitorModeManager");


void TestMonitorModeManager::setArgsTest(void)
{
  MonitorModeManager* mode_manager = MonitorModeManager::singleton();

  MonitorModeManager::MonitorMode mode = mode_manager->mode();
  CPPUNIT_ASSERT_EQUAL(MonitorModeManager::Undefined, mode);

  int argc = 2;
  char *argv[] = {
    "dummy",
    "-s",
  };
  mode_manager->setMode(argc, argv);
  mode = mode_manager->mode();
  CPPUNIT_ASSERT_EQUAL(MonitorModeManager::Simulation, mode);
}
