#ifndef MONITOR_EVENT_SCHEDULER_H
#define MONITOR_EVENT_SCHEDULER_H

/*!
  \file
  \brief モニタイベント管理

  \author Satofumi KAMIMURA

  $Id: MonitorEventScheduler.h 255 2008-10-06 11:31:15Z satofumi $
*/

#include <memory>


namespace qrk
{
  class ConditionVariable;
  class DeviceServer;
  class Lock;


  class MonitorEventScheduler
  {
    MonitorEventScheduler(void);
    MonitorEventScheduler(const MonitorEventScheduler& rhs);
    MonitorEventScheduler& operator = (const MonitorEventScheduler& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    ~MonitorEventScheduler(void);
    static MonitorEventScheduler* singleton(void);

    void registerWakeupTicks(ConditionVariable* condition, int ticks);
    void registerDeviceServer(DeviceServer* device);
  };
};

#endif /* !MONITOR_EVENT_SCHEDULER_H */
