#ifndef LOG_NAME_HOLDER_H
#define LOG_NAME_HOLDER_H

/*!
  \file
  \brief ログ名の管理

  \author Satofumi KAMIMURA

  $Id: LogNameHolder.h 286 2008-10-20 09:40:22Z satofumi $
*/

#include <memory>
#include <string>


namespace qrk
{
  class LogNameHolder
  {
    LogNameHolder(void);
    LogNameHolder(const LogNameHolder& rhs);
    LogNameHolder& operator = (const LogNameHolder& rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;

  public:
    ~LogNameHolder(void);
    static LogNameHolder* singleton(void);

    std::string name(const char* baseName);
  };
};

#endif /* !LOG_NAME_HOLDER_H */
