/*!
  \file
  \brief ログ名の管理

  \author Satofumi KAMIMURA

  $Id: LogNameHolder.cpp 286 2008-10-20 09:40:22Z satofumi $
*/

#include "LogNameHolder.h"
#include "DetectOS.h"
#include <string>
#include <map>

#ifdef MSC
#define snprintf _snprintf
#endif

using namespace qrk;


namespace
{
  typedef std::map<std::string, int> Names;
};


struct LogNameHolder::pImpl
{
  Names names_number_;


  std::string name(const char* baseName)
  {
    Names::iterator p = names_number_.find(std::string(baseName));
    int id = (p == names_number_.end()) ? 0 : names_number_[baseName] + 1;
    names_number_[baseName] = id;

    enum { BufferSize = 14 };
    char buffer[BufferSize];
    snprintf(buffer, BufferSize, "_%d", id);

    return (std::string(baseName) + buffer + ".log").c_str();
  }
};


LogNameHolder::LogNameHolder(void) : pimpl(new pImpl)
{
}


LogNameHolder::~LogNameHolder(void)
{
}


LogNameHolder* LogNameHolder::singleton(void)
{
  static LogNameHolder object;
  return &object;
}


std::string LogNameHolder::name(const char* baseName)
{
  return pimpl->name(baseName);
}
