#ifndef SDL_VIDEO_INIT_H
#define SDL_VIDEO_INIT_H

/*!
  \file
  \brief SDL_VIDEO システムの初期化

  \author Satofumi KAMIMURA

  $Id: SdlVideoInit.h 166 2008-08-24 00:37:24Z satofumi $
*/

#include <memory>


namespace qrk
{
  /*!
    \brief SDL_VIDEO システムの初期化クラス
  */
  class SdlVideoInit
  {
    SdlVideoInit(const SdlVideoInit& rhs);
    SdlVideoInit& operator = (const SdlVideoInit& rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;

  public:
    SdlVideoInit(void);
    ~SdlVideoInit(void);


    /*!
      \brief システムの初期化
    */
    void init(void);


    /*!
      \brief システムのシャットダウン
    */
    void quit(void);
  };
};

#endif /* !SDL_VIDEO_INIT_H */
