/*!
  \file
  \brief SDL_VIDEO システムの初期化

  \author Satofumi KAMIMURA

  $Id: SdlVideoInit.cpp 166 2008-08-24 00:37:24Z satofumi $
*/

#include <SDL.h>
#include "SdlVideoInit.h"
#include "SdlInit.h"

using namespace qrk;


struct SdlVideoInit::pImpl : private SdlInit
{
  static bool initialized_;
};
bool SdlVideoInit::pImpl::initialized_ = false;


SdlVideoInit::SdlVideoInit(void) : pimpl(new pImpl)
{
}


SdlVideoInit::~SdlVideoInit(void)
{
  // exit() 時に SdlInit の実装内で SDL_Quit() が呼ばれるはずなので、何もしない
}


void SdlVideoInit::init(void)
{
  if (pimpl->initialized_) {
    return;
  }
  pimpl->initialized_ = (SDL_InitSubSystem(SDL_INIT_VIDEO) < 0) ? false : true;
}


void SdlVideoInit::quit(void)
{
  SDL_QuitSubSystem(SDL_INIT_VIDEO);
  pimpl->initialized_ = false;
}
