/*!
  \file
  \brief 点列に移動平均を適用する

  \author Satofumi KAMIMURA

  $Id: shmoothPoints.cpp 222 2008-09-17 12:52:15Z satofumi $
*/

#include "shmoothPoints.h"
#include "MovingAverage.h"

using namespace qrk;


void qrk::shmoothPoints(std::vector<Grid<long> >& points)
{
  if (points.empty()) {
    return;
  }

  enum {
    AveragePoints = 3,
  };
  MovingAverage<Grid<long> > moving_average(AveragePoints);

  moving_average.push_back(points[0]);
  for (std::vector<Grid<long> >::iterator it = points.begin() + 1;
       it != points.end(); ++it) {
    moving_average.push_back(*it);

    *(it - 1) = moving_average.average();
  }
}
