#ifndef POINT_UTILS_H
#define POINT_UTILS_H

/*!
  \file
  \brief 点関連の関数

*/

#include "GridTypes.h"
#include "AngleTypes.h"
#include "MathUtils.h"


namespace qrk
{
  /*!
    \brief 線分の距離計算

    \return 線分の距離
  */
  template <class T>
  T length(const Grid<T>& a, const Grid<T>& b)
  {
    T x_diff = a.x - b.x;
    T y_diff = a.y - b.y;

    return static_cast<T>(sqrt((x_diff * x_diff) + (y_diff * y_diff)));
  }


  template <class T>
  Angle lineAngle(const Grid<T>& a, const Grid<T>& b)
  {
    double angle_radian = atan2(a.y - b.y, a.x - b.x);
    return rad(angle_radian);
  }
};

#endif /* !POINT_UTILS_H */
