/*!
  \file
  \brief メディアンフィルタを適用しつつ、点列の間隔を均等にする

  \author Satofumi KAMIMURA

  $Id: normarizePointsInterval.cpp 222 2008-09-17 12:52:15Z satofumi $
*/

#include "normarizePointsInterval.h"
#include "MovingMedian.h"
#include "pointUtils.h"

using namespace qrk;


void qrk::normarizePointsInterval(std::vector<Grid<long> >& points,
                                  int min_interval)
{
  if (points.empty()) {
    return;
  }

  enum {
    MedianPoints = 8,
  };

  MovingMedian<long> median_filter_x(MedianPoints);
  MovingMedian<long> median_filter_y(MedianPoints);
  median_filter_x.setMedianValue(points[0].x);
  median_filter_y.setMedianValue(points[0].y);

  std::vector<Grid<long> > converted_points;
  converted_points.reserve(points.size());

  Grid<long> last = Grid<long>(points[0]);
  for (std::vector<Grid<long> >::iterator it = points.begin();
       it != points.end(); ++it) {

    median_filter_x.push_back(it->x);
    median_filter_y.push_back(it->y);

    if (length<long>(*it, last) < static_cast<long>(min_interval)) {
      continue;
    }

    Grid<long> add_point = Grid<long>(median_filter_x.median(),
                                      median_filter_y.median());
    converted_points.push_back(Grid<long>(it->x, it->y));
    last = *it;
  }

  std::swap(converted_points, points);
}
