/*!
  \file
  \brief 連続した点列からの直線検出

  \author Satofumi KAMIMURA

  $Id: convertLineSegment.cpp 223 2008-09-20 02:19:33Z satofumi $

  \todo 点が -180, +180 付近になるときにも、適切に動作するようにする
*/

#include "convertLineSegment.h"
#include "pointUtils.h"
#include "angleUtils.h"

using namespace qrk;


int qrk::convertLineSegment(std::vector<Line<long> >& lines,
                            const std::vector<Grid<long> >& points)
{
  if (points.empty()) {
    return 0;
  }

  Angle judge_angle = deg(12);
  int min_points = 0;
  long min_length = 50;         // [mm]
  long max_each_length = 60;    // [mm]

  int line_points = 0;           // 線分を構成する点の数
  double pre_angle_radian = 0.0; // !!! 0.0 でよいかは未検討
  double first_angle_radian = 0.0;
  Grid<long> pre_point(points[0]);
  Grid<long> start, end;
  for (std::vector<Grid<long> >::const_iterator it = points.begin() + 1;
       it != points.end(); ++it) {

    if ((pre_point.x == it->x) && (pre_point.y == it->y)) {
      // 点の位置が同じならば、線分の存在確率のみを増加させる
      ++line_points;

    } else {
      // 直前の点と線分の向きを比較し、同じ向きが続けば線分とみなす
      Angle line_angle = lineAngle<long>(*it, pre_point);

      // なす角を求めて判定する
      Angle diff_radian = narrowAngle(line_angle, rad(pre_angle_radian));

      if (line_points == 0) {
        first_angle_radian = line_angle.to_rad();
      }

      if ((diff_radian.to_rad() <= judge_angle.to_rad()) &&
          (narrowAngle(rad(first_angle_radian), line_angle).to_rad()
           <= judge_angle.to_rad())) {

        // 線分の終端候補として今の点位置を登録する
        ++line_points;
        end = *it;

      } else {
        if (line_points > min_points) {
          // 線分を構成するだけの十分な点数があれば、既存の情報を線分とみなす
          long total_length = length<long>(start, end);
          long each_length = total_length / line_points;
          if ((total_length >= min_length) && (each_length < max_each_length)) {
            // 線分として登録する
            lines.push_back(Line<long>(start, end, line_points));
          }
        }
        // 現在位置を次の始点とみなす
        start = *it;
        end = *it;
        line_points = 0;
      }

      pre_angle_radian = line_angle.to_rad();
      pre_point = *it;
    }
  }

  // 最大の確率が 1.0 になるようにする
  // !!!
  // !!! line_points の最大値を保持しておけば、計算可能

  return lines.size();
}
