/*!
  \file
  \brief 角度関連の関数

  \author Satofumi KAMIMURA

  $Id: angleUtils.cpp 222 2008-09-17 12:52:15Z satofumi $
*/

#include "angleUtils.h"
#include "MathUtils.h"

using namespace qrk;


Angle qrk::narrowAngle(const Angle& a, const Angle& b)
{
  double diff_radian = fabs(a.to_rad() - b.to_rad());
  while (diff_radian > M_PI) {
    diff_radian -= M_PI;
  }
  if (diff_radian > (M_PI / 2.0)) {
    diff_radian = M_PI - diff_radian;
  }

  return rad(diff_radian);
}
