/*!
  \file
  \brief ShmoothPoints のテスト

  \author Satofumi KAMIMURA

  $Id: TestShmoothPoints.cpp 222 2008-09-17 12:52:15Z satofumi $
*/

#include "TestShmoothPoints.h"
#include "GridTypes.h"
#include "shmoothPoints.h"

using namespace qrk;


CPPUNIT_TEST_SUITE_REGISTRATION(TestShmoothPoints);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TestShmoothPoints, "TestShmoothPoints");


void TestShmoothPoints::shmoothTest(void)
{
  std::vector<Grid<long> > points;
  points.push_back(Grid<long>(0, 0));
  points.push_back(Grid<long>(2, 6));
  points.push_back(Grid<long>(4, 0));

  shmoothPoints(points);

  CPPUNIT_ASSERT_EQUAL(static_cast<long>(2), points[1].x);
  CPPUNIT_ASSERT_EQUAL(static_cast<long>(2), points[1].y);
}
