/*!
  \file
  \brief LineUtils のテスト

  \author Satofumi KAMIMURA

  $Id: TestLineUtils.cpp 222 2008-09-17 12:52:15Z satofumi $
*/

#include "TestLineUtils.h"
#include "lineUtils.h"

using namespace qrk;


CPPUNIT_TEST_SUITE_REGISTRATION(TestLineUtils);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TestLineUtils, "TestLineUtils");


void TestLineUtils::isCrossLineTest(void)
{
  Grid<double> a(0, 0), b(4, 0);
  Grid<double> c(1, -1), d(1, +1);
  Grid<double> p;

  bool actual = isCrossLines<double>(a, b, c, d, p);
  CPPUNIT_ASSERT_EQUAL(true, actual);

  CPPUNIT_ASSERT_EQUAL(1.0, p.x);
  CPPUNIT_ASSERT_EQUAL(0.0, p.y);

  Grid<double> e(1, 1), f(1, 2);
  actual = isCrossLines<double>(a, b, e, f, p);
  CPPUNIT_ASSERT_EQUAL(false, actual);

  Grid<double> a2(0.0, 1000.0), b2(-5.0, -4600.0);
  Grid<double> c2(0.0, 0.0), d2(-1409.0, 0.0);
  actual = isCrossLines(a2, b2, c2, d2, p);
  CPPUNIT_ASSERT_EQUAL(true, actual);
}
