/*!
  \file
  \brief GridTypes のテスト

  \author Satofumi KAMIMURA

  $Id: TestGridTypes.cpp 222 2008-09-17 12:52:15Z satofumi $
*/

#include "TestGridTypes.h"
#include "GridTypes.h"

using namespace qrk;


CPPUNIT_TEST_SUITE_REGISTRATION(TestGridTypes);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TestGridTypes, "TestGridTypes");


void TestGridTypes::compileTest(void)
{
  Grid<int> a;
}


void TestGridTypes::pluseTest(void)
{
  Grid<int> a(1, 2);
  Grid<int> b(3, 4);

  Grid<int> p = a + b;

  CPPUNIT_ASSERT_EQUAL(4, p.x);
  CPPUNIT_ASSERT_EQUAL(6, p.y);

  Grid<int> c(4, 5);
  p = a + b - c;
  CPPUNIT_ASSERT_EQUAL(0, p.x);
  CPPUNIT_ASSERT_EQUAL(1, p.y);

  p = a - b;
  CPPUNIT_ASSERT_EQUAL(-2, p.x);
  CPPUNIT_ASSERT_EQUAL(-2, p.y);
}
