#ifndef LINE_TYPES_H
#define LINE_TYPES_H

/*!
  \file
  \brief 直線の型定義

  \author Satofumi KAMIMURA

  $Id: LineTypes.h 222 2008-09-17 12:52:15Z satofumi $
*/

#include "GridTypes.h"
#include "AngleTypes.h"


namespace qrk
{
  template<class T> class Line
  {
  public:
    Grid<T> start;
    Grid<T> end;
    double probability;


    Line(const Grid<T>& start_, const Grid<T>& end_, double probability_ = 1.0)
      : start(start_), end(end_), probability(probability_)
    {
    }

    // !!!
  };
};

#endif /* !LINE_TYPES_H */
