/*!
  \file
  \brief WiiJoystick の動作サンプル

  \author Satofumi KAMIMURA

  $Id: wiiJoystickSample.cpp 200 2008-09-02 13:54:32Z satofumi $
*/

#include <SDL.h>
#include "WiiJoystick.h"
#include "delay.h"

using namespace qrk;


int main(int argc, char *argv[]) {

  WiiJoystick joystick;
  if (! joystick.connect()) {
    printf("WiiJoystick::connect: %s\n", joystick.what());
    exit(1);
  }
  printf("O.K.\n");

  size_t buttons_num = joystick.getButtonsNum();
  while (1) {

    // バッテリー情報
    printf("%d[%%], ", joystick.getBatteryPercent());

    // 軸情報
    int x_axis = joystick.getAxisValue(WiiJoystick::AxisX);
    int y_axis = joystick.getAxisValue(WiiJoystick::AxisY);
    printf("%6d, %6d: ", x_axis, y_axis);

    // ボタン情報
    for (size_t i = 0; i < buttons_num; ++i) {
      bool is_pressed = joystick.isButtonPressed(i);
      printf("%d, ", is_pressed ? 1 : 0);
    }

    // 加速度情報
    Grid3D<double> acceleration;
    joystick.getAcceleration(acceleration);
    printf("%.2f, %.2f, %.2f, ",
           acceleration.x, acceleration.y, acceleration.z);

    // IR 情報
    std::vector<WiiJoystick::ir_position> ir_positions;
    joystick.getIrPosition(ir_positions);
    if (! ir_positions.empty()) {
      printf("\n");
    }
    for (std::vector<WiiJoystick::ir_position>::iterator it =
           ir_positions.begin(); it != ir_positions.end(); ++it) {
      printf("(%.2f, %.2f, %d), ", it->position.x, it->position.y, it->size);
    }

    printf("\n");

    delay(100);
  }

  return 0;
}
