/*!
  \file
  \brief TcpipServer のテスト

  \author Satofumi KAMIMURA

  $Id: TestTcpipServer.cpp 225 2008-09-20 10:42:10Z satofumi $
*/

#include "TestTcpipServer.h"
#include "TcpipServer.h"
#include "TcpipCtrl.h"
#include "Thread.h"

using namespace qrk;


CPPUNIT_TEST_SUITE_REGISTRATION(TestTcpipServer);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TestTcpipServer, "TestTcpipServer");

enum {
  Port = 57577,
  Timeout = 1000,
};


namespace
{
  static int connectThread(void* args)
  {
    TcpipServer* server = static_cast<TcpipServer*>(args);

    return server->accept(Timeout);
  }
};


void TestTcpipServer::connectTest(void)
{
  // サーバの起動
  TcpipServer server;
  bool activated = server.activate(Port);
  CPPUNIT_ASSERT_EQUAL(true, activated);
  Thread thread(connectThread, &server);
  thread.run(1);

  // クライアントからの接続
  TcpipCtrl client;
  if (! client.connect("localhost", Port)) {
    CPPUNIT_FAIL(std::string("connection failed.: ") + client.what());
  }

  bool is_connected = thread.wait();
  CPPUNIT_ASSERT_EQUAL_MESSAGE(server.what(), true, is_connected);

  // サーバからの１文字送信
  int send_size = server.send("a", 1);
  CPPUNIT_ASSERT_EQUAL(1, send_size);

  char ch = '\0';
  int recv_size = client.recv(&ch, 1, Timeout);
  CPPUNIT_ASSERT_EQUAL(1, recv_size);
  CPPUNIT_ASSERT_EQUAL(ch, 'a');


  // クライアントからの１文字送信
  send_size = client.send("A", 1);
  CPPUNIT_ASSERT_EQUAL(1, send_size);

  ch = '\0';
  recv_size = server.recv(&ch, 1, Timeout);
  CPPUNIT_ASSERT_EQUAL(1, recv_size);
  CPPUNIT_ASSERT_EQUAL(ch, 'A');
}
