#ifndef CUSTOM_CONNECTION_H
#define CUSTOM_CONNECTION_H

/*!
  \file
  \brief 自作コネクション

  \author Satofumi KAMIMURA

  $Id: CustomConnection.h 299 2008-10-26 12:15:43Z satofumi $
*/

#include "Connection.h"
#include <string>
#include <memory>


namespace qrk
{
  class CustomConnection : public Connection
  {
    CustomConnection(const CustomConnection& rhs);
    CustomConnection& operator = (const CustomConnection& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    enum { NoTimeout = -1 };

    CustomConnection(void);
    ~CustomConnection(void);

    const char* what(void);

    bool connect(const char* device, long baudrate);
    void disconnect(void);
    bool setBaudrate(long baudrate);
    long baudrate(void);
    bool isConnected(void);
    int send(const char* data, size_t count);
    int recv(char* data, size_t count, int timeout);
    size_t size(void);
    void flush(void);
    void clear(void);
    void ungetc(const char ch);

    void setReadData(const char* data, size_t count);
    void setReadData(std::string data);
    void readSendData(char* data, size_t count);
  };
};

#endif /* !CUSTOM_CONNECTION_H */
