/*!
  \file
  \brief 自作コネクション

  \author Satofumi KAMIMURA

  $Id: CustomConnection.cpp 299 2008-10-26 12:15:43Z satofumi $
*/

#include "CustomConnection.h"
#include "RingBuffer.h"

using namespace qrk;


struct CustomConnection::pImpl
{
  long baudrate_;
  RingBuffer<char> recv_buffer_;
  RingBuffer<char> send_buffer_;


  pImpl(void) : baudrate_(0)
  {
  }
};


CustomConnection::CustomConnection(void) : pimpl(new pImpl)
{
}


CustomConnection::~CustomConnection(void)
{
}


const char* CustomConnection::what(void)
{
  return "Not implemented.";
}


bool CustomConnection::connect(const char* device, long baudrate)
{
  // !!!
  return true;
}


void CustomConnection::disconnect(void)
{
  // !!!
}


bool CustomConnection::setBaudrate(long baudrate)
{
  pimpl->baudrate_ = baudrate;
  return true;
}


long CustomConnection::baudrate(void)
{
  return pimpl->baudrate_;
}


bool CustomConnection::isConnected(void)
{
  // !!!
  return false;
}


int CustomConnection::send(const char* data, size_t count)
{
  // !!!
  return count;
}


int CustomConnection::recv(char* data, size_t count, int timeout)
{
  int n = std::min(pimpl->recv_buffer_.size(), count);
  pimpl->recv_buffer_.get(data, n);
  return n;
}


size_t CustomConnection::size(void)
{
  return pimpl->recv_buffer_.size();
}


void CustomConnection::flush(void)
{
  // !!!
}


void CustomConnection::clear(void)
{
  // 登録内容を全てクリアする
  pimpl->recv_buffer_.clear();
  pimpl->send_buffer_.clear();
}


void CustomConnection::ungetc(const char ch)
{
  pimpl->recv_buffer_.ungetc(ch);
}


void CustomConnection::setReadData(const char* data, size_t count)
{
  pimpl->recv_buffer_.put(data, count);
}


void CustomConnection::setReadData(std::string data)
{
  pimpl->recv_buffer_.put(data.c_str(), data.size());
}


void CustomConnection::readSendData(char* data, size_t count)
{
  pimpl->send_buffer_.put(data, count);
}
