#ifndef CONNECTION_RECORDER_H
#define CONNECTION_RECORDER_H

/*!
  \file
  \brief 通信データの記録

  \author Satofumi KAMIMURA

  $Id: ConnectionRecorder.h 212 2008-09-04 03:48:22Z satofumi $

  \todo データ取得タイミングの概念を導入するか検討する
*/

#include <memory>
#include "Connection.h"


namespace qrk
{
  /*!
    \brief 通信データの記録クラス
  */
  class ConnectionRecorder : public Connection
  {
    ConnectionRecorder(void);
    ConnectionRecorder(const ConnectionRecorder& rhs);
    ConnectionRecorder& operator = (const ConnectionRecorder& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    enum { NoTimeout = -1 };

    ConnectionRecorder(Connection* con);
    ~ConnectionRecorder(void);

    const char* what(void);

    bool connect(const char* device, long baudrate);
    void disconnect(void);
    bool setBaudrate(long baudrate);
    long baudrate(void);
    bool isConnected(void);
    int send(const char* data, size_t count);
    int recv(char* data, size_t count, int timeout);
    size_t size(void);
    void flush(void);
    void clear(void);
    void ungetc(const char ch);

    /*!
      \brief 記録用のファイル名を変更する

      以降の送受信データは、以下の２つのファイル名に出力される

      - <ファイルの基本名>_send.txt
      - <ファイルの基本名>_recv.txt

      \param[in] basename ファイルの基本名
    */
    void setBasename(const char* basename);
  };
};

#endif /* !CONNECTION_RECORDER_H */
