#ifndef STRING_SPLIT_H
#define STRING_SPLIT_H

/*!
  \file
  \brief string 用の split 関数

  \author Satofumi KAMIMURA

  $Id: split.h 188 2008-08-30 12:23:34Z satofumi $
*/

#include <vector>
#include <string>


namespace qrk
{
  /*!
    \brief 指定文字による分割

    \param[out] tokens 分割後の文字列
    \param[in] original 分割対象の文字列
    \param[in] split_pattern 分割を行う文字の列

    \return 分割後のトークン数
  */
  size_t split(std::vector<std::string>& tokens,
               const std::string& original, const char* split_pattern = " \t");
};

#endif /* !STRING_SPLIT_H */
