/*!
  \file
  \brief RingBuffer のテスト

  \author Satofumi KAMIMURA

  $Id: TestRingBuffer.cpp 166 2008-08-24 00:37:24Z satofumi $
*/

#include "TestRingBuffer.h"
#include "RingBuffer.h"

using namespace qrk;


CPPUNIT_TEST_SUITE_REGISTRATION(TestRingBuffer);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TestRingBuffer, "TestRingBuffer");


void TestRingBuffer::compileTest(void)
{
  RingBuffer<char> buffer;
}


void TestRingBuffer::putTest(void)
{
  RingBuffer<char> buffer;
  CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(0), buffer.size());

  buffer.put("0", 1);
  CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), buffer.size());

  char ch;
  int n = buffer.get(&ch, 1);
  CPPUNIT_ASSERT_EQUAL('0', ch);
  CPPUNIT_ASSERT_EQUAL(1, n);

  buffer.clear();
  CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(0), buffer.size());
}


void TestRingBuffer::extendTest(void)
{
  RingBuffer<char> buffer;

  char recvBuffer[] = { '\0', '\0', '\0', '\0',
                        '\0', '\0', '\0', '\0', '\0' };

  buffer.put("0", 1);
  int n = buffer.get(recvBuffer, 8);
  CPPUNIT_ASSERT_EQUAL(1, n);
  CPPUNIT_ASSERT_EQUAL(std::string("0"), std::string(recvBuffer));

  buffer.put("1", 1);
  n = buffer.get(recvBuffer, 8);
  CPPUNIT_ASSERT_EQUAL(1, n);
  CPPUNIT_ASSERT_EQUAL(std::string("1"), std::string(recvBuffer));

  buffer.put("23", 2);
  n = buffer.get(recvBuffer, 8);
  CPPUNIT_ASSERT_EQUAL(2, n);
  CPPUNIT_ASSERT_EQUAL(std::string("23"), std::string(recvBuffer));

  buffer.put("01234567", 8);
  n = buffer.get(recvBuffer, 8);
  CPPUNIT_ASSERT_EQUAL(8, n);
  CPPUNIT_ASSERT_EQUAL(std::string("01234567"), std::string(recvBuffer));
}


void TestRingBuffer::rotateTest(void)
{
  RingBuffer<char> buffer;

  char recvBuffer[] = { '\0', '\0', '\0', '\0', '\0' };

  for (int i = 0; i < 3; ++i) {
    char ch = '0' + i;
    buffer.put(&ch, 1);
  }
  int n = buffer.get(recvBuffer, 3);
  CPPUNIT_ASSERT_EQUAL(3, n);
  CPPUNIT_ASSERT_EQUAL(std::string("012"), std::string(recvBuffer));

  buffer.put("abc", 3);
  n = buffer.get(recvBuffer, 3);
  CPPUNIT_ASSERT_EQUAL(3, n);
  CPPUNIT_ASSERT_EQUAL(std::string("abc"), std::string(recvBuffer));
}
