/*!
  \file
  \brief LeastSquare のテスト

  \author Satofumi KAMIMURA

  $Id: TestLeastSquare.cpp 222 2008-09-17 12:52:15Z satofumi $
*/

#include "TestLeastSquare.h"
#include "LeastSquare.h"

using namespace qrk;


CPPUNIT_TEST_SUITE_REGISTRATION(TestLeastSquare);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TestLeastSquare, "TestLeastSquare");


void TestLeastSquare::compileTest(void)
{
  LeastSquare<double> least_square;
}


void TestLeastSquare::calculateTest(void)
{
  LeastSquare<double> least_square;
  least_square.push_back(1.0, 1.0);
  least_square.push_back(2.0, 2.0);
  least_square.push_back(3.0, 3.0);

  Angle actual_angle = least_square.gradients();
  CPPUNIT_ASSERT_EQUAL(45, actual_angle.to_deg());

  double actual_intercepts = least_square.intercepts();
  CPPUNIT_ASSERT_EQUAL(0.0, actual_intercepts);
}


void TestLeastSquare::clearTest(void)
{
  LeastSquare<double> least_square;
  least_square.push_back(-100.0, 100.0);

  least_square.clear();

  least_square.push_back(1.0, 1.0);
  least_square.push_back(2.0, 2.0);
  least_square.push_back(3.0, 3.0);

  Angle actual_angle = least_square.gradients();
  CPPUNIT_ASSERT_EQUAL(45, actual_angle.to_deg());

  double actual_intercepts = least_square.intercepts();
  CPPUNIT_ASSERT_EQUAL(0.0, actual_intercepts);
}
