#ifndef QRK_SERIAL_CONNECTION_WIDGET_SAMPLE_H
#define QRK_SERIAL_CONNECTION_WIDGET_SAMPLE_H

/*!
  \file
  \brief SerialConnectionWidget の動作確認ウィジット

  \author Satofumi KAMIMURA

  $Id: SerialConnectionWidgetSample.h 1979 2012-04-05 16:26:14Z satofumi $
*/

#include "ui_SerialConnectionWidgetSampleForm.h"
#include <memory>


class SerialConnectionWidgetSample
  : public QWidget, private Ui::SerialConnectionWidgetSampleForm
{
  Q_OBJECT;

public:
  SerialConnectionWidgetSample(QWidget* parent = 0);
  ~SerialConnectionWidgetSample(void);

private slots:
  void connectPressed(bool connection, const std::string& device);
  void rescanPressed(void);

private:
  SerialConnectionWidgetSample(const SerialConnectionWidgetSample& rhs);
  SerialConnectionWidgetSample& operator
  = (const SerialConnectionWidgetSample& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;
};

#endif /* !QRK_SERIAL_CONNECTION_WIDGET_SAMPLE_H */
