/*!
  \file
  \brief 再生時の接続用スレッド

  \author Satofumi KAMIMURA

  $Id: RangeSensorConnectThread.cpp 1775 2010-04-12 21:38:30Z satofumi $
*/

#include "RangeSensorConnectThread.h"
#include "RangeSensor.h"
#include "UrgDevice.h"

using namespace qrk;
using namespace std;


struct RangeSensorConnectThread::pImpl
{
  RangeSensor& sensor_;

  string device_;
  long baudrate_;


  pImpl(RangeSensor& sensor)
    : sensor_(sensor), device_("dummy"), baudrate_(UrgDevice::DefaultBaudrate)
  {
  }
};


void RangeSensorConnectThread::run(void)
{
  bool ret = pimpl->sensor_.connect(pimpl->device_.c_str(), pimpl->baudrate_);
  emit connected(ret);
}


RangeSensorConnectThread::RangeSensorConnectThread(RangeSensor& sensor)
  : pimpl(new pImpl(sensor))
{
}


RangeSensorConnectThread::~RangeSensorConnectThread(void)
{
}


void RangeSensorConnectThread::setConnectSettings(const string& device,
                                                  long baudrate)
{
  pimpl->device_ = device;
  pimpl->baudrate_ = baudrate;
}
