#ifndef TRANSMIT_THREAD_H
#define TRANSMIT_THREAD_H

/*!
  \file
  \brief mot ファイルの転送スレッド

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QThread>
#include <memory>

namespace qrk
{
  class Connection;
}


class TransmitThread : public QThread
{
  Q_OBJECT;

public:
  TransmitThread(void);
  ~TransmitThread(void);

  void setSettings(qrk::Connection& connection,
                   const QString& file, size_t file_lines,
                   const QString& device);

protected:
  void run(void);

signals:
  void percent(int);
  void success(void);
  void fail(void);

private:
  TransmitThread(const TransmitThread& rhs);
  TransmitThread& operator = (const TransmitThread& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;
};

#endif /* !TRANSMIT_THREAD_H */
