/*!
  \file
  \brief mot ファイルのダンプ

  \author Satofumi KAMIMURA

  $Id: mot2data.cpp 1497 2009-11-04 12:46:44Z satofumi $
*/

#include "FZtatHandler.h"
#include "SformatSender.h"
#include "SformatSender.h"
#include "stub_sh7045.h"
#include "TcpipSocket.h"
#include "Thread.h"
#include <iostream>
#include <cstdlib>

using namespace qrk;
using namespace std;


namespace
{
  enum {
    Port = 7045,
  };


  Thread* thread_ = NULL;
  static const char writer_program[] = "";


  void runStub(void)
  {
    long port = Port;
    thread_ = new Thread(stub_sh7045, &port);
    thread_->run();
  }
}


int main(int argc, char *argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  runStub();
  TcpipSocket connection;
  if (! connection.connect("localhost", Port)) {
    cout << "Coudn't connect: localhost, " << Port << endl;
    exit(1);
  }

  FZtatHandler fztat;
  size_t send_size = sizeof(writer_program) - 1;
  if (! fztat.transfer(&connection, writer_program, send_size)) {
    cout << fztat.what() << endl;
    exit(1);
  }

  enum { TransferBaudrate = 115200 };
  SformatSender sformat(&connection, TransferBaudrate);
  sformat.setDumpFile("writer_program.h");
  if (! sformat.send("writer_sh7045.mot")) {
    cout << sformat.what() << endl;
    exit(1);
  }

  return 0;
}
