/*!
  \file
  \brief SformatHandler のテスト

  \author Satofumi KAMIMURA

  $Id: TestSformatHandler.cpp 1474 2009-11-01 05:33:08Z satofumi $
*/

#include "TestSformatHandler.h"
#include "SformatHandler.h"
#include <string>
#include <cstdlib>

using namespace qrk;
using namespace std;


CPPUNIT_TEST_SUITE_REGISTRATION(TestSformatHandler);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TestSformatHandler, "TestSformatHandler");


void TestSformatHandler::parseTest(void)
{
  string line;
  SformatHandler::sformat_t mot;

  line = "S00C000068656C6C6F2E6D6F7461\0";
  SformatHandler::parseSformat(&mot, line);
  CPPUNIT_ASSERT_EQUAL(0, static_cast<int>(mot.type - '0'));

  line = "S1130010000010000000100000001000000010009C\0";
  SformatHandler::parseSformat(&mot, line);
  CPPUNIT_ASSERT_EQUAL(1, static_cast<int>(mot.type - '0'));
  CPPUNIT_ASSERT_EQUAL(static_cast<unsigned long>(0x0010), mot.address);
  size_t data_size = static_cast<int>(strtol("13", NULL, 16)) - 3;
  CPPUNIT_ASSERT_EQUAL(data_size, mot.data.size());
  CPPUNIT_ASSERT_EQUAL(static_cast<char>(0x00), mot.data[0]);
  CPPUNIT_ASSERT_EQUAL(static_cast<char>(0x10), mot.data[14]);
  CPPUNIT_ASSERT_EQUAL(static_cast<char>(0x00), mot.data[15]);

  line = "S21440000000400274004FFFF000400274004FFFF0C3\0";
  SformatHandler::parseSformat(&mot, line);
  CPPUNIT_ASSERT_EQUAL(2, static_cast<int>(mot.type - '0'));
  CPPUNIT_ASSERT_EQUAL(static_cast<unsigned long>(0x400000), mot.address);
  data_size = static_cast<int>(strtol("14", NULL, 16)) - 4;
  CPPUNIT_ASSERT_EQUAL(data_size, mot.data.size());
  CPPUNIT_ASSERT_EQUAL(static_cast<char>(0x00), mot.data[0]);
  CPPUNIT_ASSERT_EQUAL(static_cast<char>(0xf0), mot.data[15]);

  line = "S2084FFFF0DEADDEADA3\0";
  SformatHandler::parseSformat(&mot, line);
  CPPUNIT_ASSERT_EQUAL(2, static_cast<int>(mot.type - '0'));
  CPPUNIT_ASSERT_EQUAL(static_cast<unsigned long>(0x4ffff0), mot.address);
  data_size = static_cast<int>(strtol("08", NULL, 16)) - 4;
  CPPUNIT_ASSERT_EQUAL(data_size, mot.data.size());
  CPPUNIT_ASSERT_EQUAL(static_cast<char>(0xde), mot.data[0]);
  CPPUNIT_ASSERT_EQUAL(static_cast<char>(0xad), mot.data[1]);
  CPPUNIT_ASSERT_EQUAL(static_cast<char>(0xde), mot.data[2]);
  CPPUNIT_ASSERT_EQUAL(static_cast<char>(0xad), mot.data[3]);

  line = "S80440027445\0";
  SformatHandler::parseSformat(&mot, line);
  CPPUNIT_ASSERT_EQUAL(8, static_cast<int>(mot.type - '0'));
  CPPUNIT_ASSERT_EQUAL(static_cast<unsigned long>(0x400274), mot.address);

  line = "S9031000EC\0";
  SformatHandler::parseSformat(&mot, line);
  CPPUNIT_ASSERT_EQUAL(9, static_cast<int>(mot.type - '0'));
  CPPUNIT_ASSERT_EQUAL(static_cast<unsigned long>(0x1000), mot.address);
}
