#ifndef F_ZTAT_TRANSFER_H
#define F_ZTAT_TRANSFER_H

/*!
  \file
  \brief F-ZTAT の処理

  \author Satofumi KAMIMURA

  $Id: FZtatHandler.h 1950 2011-05-07 08:18:39Z satofumi $
*/

#include <memory>
#include <cstddef>

namespace qrk
{
  class Connection;
}


//! F-ZTAT の処理クラス
class FZtatHandler
{
public:
  FZtatHandler(void);
  virtual ~FZtatHandler(void);

  virtual void progress(double percent)
  {
    static_cast<void>(percent);
  }

  const char* what(void) const;

  bool transfer(qrk::Connection* connection,
                const char* writer_program, size_t send_size);

private:
  FZtatHandler(const FZtatHandler& rhs);
  FZtatHandler& operator = (const FZtatHandler& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;
};

#endif /* !F_ZTAT_TRANSFER_H */
