#!/usr/bin/ruby
# -*- coding: utf-8 -*-
# 静的リンクが、ベース名に収まっているかを確認するスクリプト
# Satofumi KAMIMURA
#
# 処理概要
# - .html に対して以下の処理を行う
#   - a href="(.+)" をリンクとして抜き出す
#   - リンク先のファイルが存在しなければ、エラー表示
#     - 存在したときに、それがベース名と一致しなければ、エラー表示

require 'find'
require 'fileutils'


# ベース名の指定がなければ、使い方を表示して終了
if ARGV.size < 1
  print "usage:\n\t" + __FILE__ + "/path/of/base/dir/\n\n"
  exit
end
base_dir = ARGV[0]


# 拡張子が html のファイル一覧を取得
check_links = {}
Find.find(base_dir) { |fname|
  if File.extname(fname) != '.html'
    next
  end
  # 対象ファイルから、リンク先文字列を抽出
  File.open(fname, "r:utf-8") { |io|
    line_count = 0
    while line = io.gets

      while line =~ /a href="(.+?)"/
        line = $'

        # '#' 以降を除去。空になった場合は登録しない
        link_name = $1.gsub(/[#&](.*)/, '');
        if ! link_name.empty?
          check_links[link_name] = fname + ':' + line_count.to_s + ':'
        end
      end
      line_count += 1
    end
  }
}
# !!! base_dir が存在しないときのチェックをするべき


# ファイルのパス名がベースディレクトリと同じかを確認
check_links.each { |key, value|

  # 'http', 'mailto' から始まるリンク先はチェックしない
  if (key[0, 4].downcase == 'http') or (key[0, 6].downcase == 'mailto')
    next
  end
  check_name = base_dir + key

  # ファイルの存在確認
  if ! FileTest.exist?(check_name)
    print value + ' ' + key + ": No such file\n"
    next
  end

  # 絶対パス名が、base_dir を含むかを確認
  absolute_path = File.expand_path(check_name)
  if absolute_path.match(base_dir) == nil
    print value + ' ' + key + ": No match file on absolute path\n"
  end

  #print key, ' ', value, "\n"
}


# ベースディレクトリとの比較に失敗したファイル名を出力
# !!!
